import pickle
import sys
import os
import numpy as np
from numpy import random as rand
import time
import functools, multiprocessing
import pandas as pd
from VarianceSimsTools import run_sample_sim
from multiprocessing import Pool


def parallelize_variance_comp(sims, arms, homogeneous, threshold, iterations, two_spheres, dimension_vec, p_vec):
    #parallelization function
    num_cores =  multiprocessing.cpu_count()
    print(num_cores)
    #pool = Pool(num_cores)
    pool = Pool(1)
    multiproc_func = functools.partial(run_sample_sim, arms, homogeneous, threshold, iterations, two_spheres, dimension_vec, p_vec)
    return pd.concat(pool.map(multiproc_func, range(sims)))

sims = 32
arms = 2000
homogeneous = False
threshold = -1
iterations = 1000
dimension_vec =  [3,6,9,12,15]
two_spheres= True
p_vec = [0.1]

if __name__ == '__main__':
    print("hello world")
    df = parallelize_variance_comp(sims, arms, homogeneous, threshold, iterations, two_spheres, dimension_vec, p_vec)
    df.to_pickle("./Variance_Simulation_Results.pkl") 


